/******************************************************************
/* [COMIDAS sample program by COMIZOA Inc., Ltd]
/*
/* - Subject : Digital Output
/* - Contents:  α׷ COMI_DO_PutAllEx()Լ ϴ Դϴ.
/*   COMI_DI_PutAllEx()Լ CH32̻   ä ¸ 
/*     մϴ.
/******************************************************************/

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "Comidas.h"

#define DEV_ID	COMI_SD402

void main (void)
{
	HANDLE hDevice;
	DWORD do_states[2]={0x0, 0x0};

	if(!COMI_LoadDll()){
		printf("Comidas.dll load failure");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}

	hDevice = COMI_LoadDevice (DEV_ID, 0);
	if(hDevice == INVALID_HANDLE_VALUE){
		printf("Can't load specified device!");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		COMI_UnloadDll();
		exit(0);
	}
	
	printf("DIO ׽Ʈ Ϸ ƹŰ ʽÿ.\n");
	printf("ƹŰ ٽ  α׷ ˴ϴ.\n");
	_getch();

	while(!kbhit())
	{
		do_states[0] = ~do_states[0];  /* toggle the states of D/O channels */
		COMI_DO_PutAllEx(hDevice, 0, do_states[0]);/* Put first 32 D/O channels (CH0~CH31) */
		
		do_states[1] = ~do_states[1];  /* toggle the states of D/O channels */
		COMI_DO_PutAllEx(hDevice, 1, do_states[1]); /* Put second 32 D/O channels (CH32~CH63) */
				
		printf("D/O States : CH0~CH31=%08lx  CH32~CH63=%08lx\n", 
			do_states[0], do_states[1]);
		Sleep(500);
	}
	
	COMI_UnloadDevice(hDevice);
	COMI_UnloadDll();
}
